# 🌱 Tairuma Node Guide v3.1 (English)

Welcome to the Tairuma network. By running this node, you become part of the forest, helping to sustain the economy of trust.

## 💰 Token Value
**1 Numa = 1€ (reference value)**

This helps you set fair prices. A service worth 20€ = **20 Numas**. New users receive **100 Numas** (≈ 100€) to start trading immediately.

## Requirements
- **OS**: Windows 10/11, macOS, or Linux.
- **Python**: Version 3.10 or higher.

## Installation & Run

### Windows
1.  Unzip the file into a folder.
2.  Run `INICIAR_BOSQUE.bat` (Double-click).
3.  The script will auto-setup everything. **Keep the window open**.
4.  Your browser will open at `http://localhost:9500`.

### macOS / Linux
1.  Open a terminal and go to the folder: `cd path/to/tairuma`.
2.  Run: `chmod +x run_node.sh && ./run_node.sh`.

## Getting Started
1.  **Register**: Use an **Invitation Code** from another user (e.g., `Numa_Fundador`).
2.  **Seed Phrase**: Save your 12 words securely. They are your only key. **Never share them.**
3.  **Profile**: Set your "Zone" to see local trade in your neighborhood.

## 🔐 Security (v3.1)
- **JWT Auth**: Sessions are protected with signed tokens (72h validity).
- **Secure Transfers**: Only you can send from your account.
- **Protected Chat**: Nobody can send messages as you.
- **Validated P2P**: Nodes only accept valid URLs with rate limiting.

## 🌐 The Economic Forest (P2P Network)
Tairuma is a decentralized P2P network:
- **Discovery**: Nodes find each other automatically (gossip protocol).
- **Independence**: Each node has its own database. Nobody can modify your balance remotely.
- **Security**: Nodes validate URLs and limit announcements to prevent attacks.

## Docker (Optional)
```bash
docker build -t tairuma .
docker run -p 9500:9500 -v ./tairuma.db:/app/tairuma.db tairuma
```

## Troubleshooting
- **"Connection Error"**: Ensure `INICIAR_BOSQUE.bat` is still running.
- **Python**: If auto-install fails, download it from `python.org`.
- **Port in use**: Change it with `PORT=9501`.

Thank you for sowing trust. 🌳
