# 🌿 Guía de Supervivencia: Tairuma v3.1

Bienvenido al bosque digital. **Tairuma** no es solo una app, es un sistema de economía natural diseñado para comunidades reales.

Aquí no hay bancos, no hay comisiones ocultas y la "moneda" (Numas) es solo una herramienta de confianza.

## 💰 Valor del Numa
**1 Numa = 1€ (valor de referencia)**

Esto te permite fijar precios justos. Si ofreces un servicio que valdría 20€, ponle un precio de **20 Numas**. Al registrarte recibes **100 Numas** (equivalentes a 100€) para empezar a intercambiar.

## Requisitos
- **Sistema Operativo**: Windows 10/11, macOS, o Linux.
- **Python**: Versión 3.10 o superior.

## Instalación y Ejecución

### En Windows
1.  Descomprime el archivo ZIP en una carpeta.
2.  Busca el archivo `INICIAR_BOSQUE.bat` y haz doble clic sobre él.
3.  Se abrirá una ventana que configurará todo automáticamente (Python, Red, etc.). **No la cierres**.
4.  Tu navegador se abrirá en `http://localhost:9500`.

### En macOS / Linux
1.  Abre una terminal y navega a la carpeta: `cd ruta/a/tairuma`.
2.  Dale permisos y ejecuta: `chmod +x run_node.sh && ./run_node.sh`.

## Primeros Pasos
1.  **Registro**: Necesitarás un **Código de Invitación** de otro usuario (ej: `Numa_Fundador`).
2.  **Semilla**: Guarda tus 12 palabras. Son tu única llave. **No las compartas nunca.**
3.  **Perfil**: Elige tu "Zona" para ver el comercio de tu barrio.

## 🔐 Seguridad (v3.1)
- **JWT**: Tu sesión está protegida con tokens firmados (72h de duración).
- **Transferencias seguras**: Solo tú puedes enviar desde tu cuenta.
- **Chat protegido**: Nadie puede enviar mensajes en tu nombre.
- **Red P2P validada**: Los nodos solo aceptan URLs válidas y con límite de frecuencia.

## 🌐 ¿Cómo se conecta el Bosque? (Red P2P)

Tairuma es una red P2P descentralizada:

1.  **Descubrimiento**: Los nodos se descubren entre sí automáticamente (protocolo gossip).
2.  **Independencia**: Cada nodo tiene su propia base de datos. Nadie puede modificar tu saldo remotamente.
3.  **Seguridad**: Los nodos validan URLs y limitan anuncios para evitar ataques.

### 🛡️ Tu Privacidad
Tus datos viven en tu PC (`tairuma.db`). El túnel de Cloudflare permite que la red te vea de forma segura sin abrir puertos en tu router.

## Docker (Opcional)
```bash
docker build -t tairuma .
docker run -p 9500:9500 -v ./tairuma.db:/app/tairuma.db tairuma
```

## Solución de Problemas
- **"Error de Conexión"**: Asegúrate de que `INICIAR_BOSQUE.bat` siga abierto.
- **Python**: Si el script falla al instalarlo, bájalo de `python.org`.
- **Puerto ocupado**: Cambia el puerto con la variable `PORT=9501`.

Gracias por sembrar confianza. 🌳
