@echo off
setlocal EnableDelayedExpansion
cls
chcp 65001 >NUL
title Tairuma Master Node

echo.
echo =======================================================
echo          BOSQUE TAIRUMA - INICIO UNIFICADO
echo =======================================================
echo.

:: 1. VERIFICACION DE PYTHON
python --version >NUL 2>&1
if %ERRORLEVEL% NEQ 0 (
    echo [!] Python no detectado. Iniciando instalacion automatica...
    echo     Esto puede tardar unos minutos. Por favor, espera...
    
    set "PY_URL=https://www.python.org/ftp/python/3.11.5/python-3.11.5-amd64.exe"
    set "PY_EXE=python_installer.exe"
    
    powershell -Command "Invoke-WebRequest -Uri '%PY_URL%' -OutFile '%PY_EXE%'"
    echo [!] Instalando Python... (Acepta los permisos si aparecen)
    start "" /wait %PY_EXE% /quiet InstallAllUsers=1 PrependPath=1
    del %PY_EXE%
    
    :: Refrescar el PATH para esta sesion
    set "PATH=%PATH%;%ProgramFiles%\Python311\;%ProgramFiles%\Python311\Scripts\"
    
    python --version >NUL 2>&1
    if %ERRORLEVEL% NEQ 0 (
        echo [ERROR] No se pudo instalar Python automaticamente. 
        echo         Por favor, instala Python manualmente desde python.org e intentalo de nuevo.
        pause
        exit /b
    )
    echo [OK] Python instalado con exito.
)

:: 2. AUTO-CONFIGURACION DE ENTORNO
if not exist "venv" (
    echo [1/5] Creando entorno virtual de Python...
    python -m venv venv
)
call venv\Scripts\activate
echo [2/5] Verificando dependencias...
pip install -r requirements.txt >NUL 2>&1

:: ------- CONFIGURACION DE PUERTO -------
:: El nodo corre en puerto 9500 por defecto
set "NODE_PORT=9500"
set "PORT=%NODE_PORT%"

:: 3. CLOUDFLARE TUNNEL (AUTO-DOWNLOAD)
if not exist "cloudflared.exe" (
    echo [3/5] Descargando herramienta de red segura...
    powershell -Command "Invoke-WebRequest -Uri 'https://github.com/cloudflare/cloudflared/releases/latest/download/cloudflared-windows-amd64.exe' -OutFile 'cloudflared.exe'"
)

:: 4. INICIAR TUNEL PUBLICO (apunta al mismo puerto que el nodo)
echo [4/5] Activando conexion publica (Tunel)...
taskkill /F /IM cloudflared.exe >NUL 2>&1
start "Cloudflare Tunnel" /B cloudflared.exe tunnel --url http://localhost:%NODE_PORT% > tunnel.log 2>&1

echo      Esperando respuesta de la red (10s)...
ping -n 11 127.0.0.1 >NUL

:: 5. EXTRAER URL PUBLICA (Logica Robusta)
set "PUBLIC_URL="
for /f "tokens=*" %%i in ('findstr "trycloudflare.com" tunnel.log') do (
    set "LINE=%%i"
    for %%a in (!LINE!) do (
        echo %%a | findstr "trycloudflare.com" >nul
        if !errorlevel! equ 0 (
            set "PUBLIC_URL=%%a"
        )
    )
)
:: Limpieza de caracteres extra
set "PUBLIC_URL=!PUBLIC_URL:|=!"
set "PUBLIC_URL=!PUBLIC_URL: =!"

if "!PUBLIC_URL!"=="" (
    echo [!] Error: No se pudo generar la direccion publica. 
    echo     Revisa tu conexion a internet o tunnel.log.
    pause
    exit /b
)

echo.
echo [EXITO] Tu Nodo esta en linea: !PUBLIC_URL!
echo.

:: 6. ACTUALIZAR SEED_NODES.JSON — AGREGAR mi URL sin borrar las existentes
:: Leemos el nodo semilla principal del archivo actual (si existe)
set "EXISTING_SEED="
if exist "seed_nodes.json" (
    for /f "usebackq tokens=*" %%s in (`findstr "https://" seed_nodes.json`) do (
        set "SEED_LINE=%%s"
        set "SEED_LINE=!SEED_LINE:"=!"
        set "SEED_LINE=!SEED_LINE:,=!"
        set "SEED_LINE=!SEED_LINE: =!"
        if not "!SEED_LINE!"=="!PUBLIC_URL!" (
            set "EXISTING_SEED=!SEED_LINE!"
        )
    )
)

:: Escribir seed_nodes.json con ambos: el existente y mi URL
if not "!EXISTING_SEED!"=="" (
    echo [INFO] Nodo semilla existente: !EXISTING_SEED!
    (
    echo [
    echo     "!PUBLIC_URL!",
    echo     "!EXISTING_SEED!"
    echo ]
    ) > seed_nodes.json
) else (
    (
    echo [
    echo     "!PUBLIC_URL!"
    echo ]
    ) > seed_nodes.json
)

:: Tambien mantener web/nodes.json para el frontend
copy /Y seed_nodes.json web\nodes.json >NUL

:: 7. CONFIGURAR URL PUBLICA PARA EL NODO P2P
set "TAIRUMA_PUBLIC_URL=!PUBLIC_URL!"

echo [5/5] Anunciandome al Bosque P2P...

echo.
echo =======================================================
echo   TODO LISTO. TU NODO YA ES PARTE DEL BOSQUE.
echo   URL Publica: !PUBLIC_URL!
echo   Puerto local: %NODE_PORT%
echo   Red P2P activa - sin dependencias externas.
echo   Manten esta ventana abierta.
echo =======================================================
echo.

:: 8. LANZAR EL NODO (con URL publica como variable de entorno)
python main.py

pause
