#!/bin/bash

# Configuration
NODE_PORT=9500
PUBLIC_URL="http://tairuma-community.duckdns.org"

# Ensure Python 3
if ! command -v python3 &> /dev/null; then
    echo "Error: Python 3 could not be found. Please install it."
    exit 1
fi

# Activate venv if exists
if [ -d "venv" ]; then
    source venv/bin/activate
else
    echo "Creating virtual environment..."
    python3 -m venv venv
    source venv/bin/activate
    pip install -r requirements.txt
fi

# Update nodes.json with our static URL
echo "Configuring node URL: $PUBLIC_URL"
echo "[\"$PUBLIC_URL\"]" > web/nodes.json

# Update seed_nodes.json if needed (append logic could be added here, but simple overwrite is safer for single node)
echo "[\"$PUBLIC_URL\"]" > seed_nodes.json

echo "======================================================="
echo "   TAIRUMA NAS NODE - LINUX"
echo "   Public URL: $PUBLIC_URL"
echo "   Port: $NODE_PORT"
echo "======================================================="

# Run the node
export PORT=$NODE_PORT
python3 main.py
